//texture tex0 < string name = "River.tga"; >;
//texture tex1 < string name = "RiverMovement.tga"; >;
//texture tex2 < string name = "TerraIncog.dds"; >;		// Borders texture
//texture tex3 < string name = "colormap_water.dds"; >;


float4x4 WorldMatrix; 
float4x4 ViewMatrix; 
float4x4 ProjectionMatrix; 
float4x4 AbsoluteWorldMatrix;
float	 vTime;

sampler BaseTexture  =
sampler_state
{
##	Texture = <tex0>;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = Repeat;
	WrapT = Repeat;
};

sampler AnimatedTexture  =
sampler_state
{
##	Texture = <tex1>;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = Repeat;
	WrapT = Repeat;
};

sampler TerraIncognitaTexture =
sampler_state
{
##	Texture = <tex2>;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};

sampler Water =
sampler_state
{
##	Texture = <tex3>;
	MinFilter = Linear;
	MagFilter = Linear;
	WrapS = ClampToEdge;
	WrapT = ClampToEdge;
};


struct VS_INPUT
{
    float4 vPosition  : POSITION;
    float2 vTexCoord0 : TEXCOORD0;
    float2 vTexCoord1 : TEXCOORD1;
};

struct VS_OUTPUT
{
    float4  vPosition  : POSITION;
    float2  vTexCoord0 : TEXCOORD0;
    float2  vTexCoord1 : TEXCOORD1;
    float2  vTerrainTexCoord : TEXCOORD2;
    float2  vWaterTexCoord : TEXCOORD3;
};


VS_OUTPUT VertexShader_River(const VS_INPUT v )
{
	VS_OUTPUT Out = (VS_OUTPUT)0;
	float4x4 WorldView = mul(WorldMatrix, ViewMatrix);
	float3 P = mul(v.vPosition, (float4x3)WorldView);
	Out.vPosition  = mul(float4(P, 1), ProjectionMatrix);

	Out.vTexCoord0 = v.vTexCoord0;
	Out.vTexCoord1 = v.vTexCoord1 + float2( 0, -vTime* 0.3 );

	float4 WorldPosition = mul( v.vPosition, AbsoluteWorldMatrix );
	Out.vTerrainTexCoord  = float2( WorldPosition.x/2048.0f, WorldPosition.z/1024.0f );
	Out.vWaterTexCoord = float2( WorldPosition.x/2048.0f, WorldPosition.z/1024.0f );

	return Out;
}

float4 PixelShader_River( VS_OUTPUT v ) : COLOR
{
	float4 OutColor = tex2D( BaseTexture, v.vTexCoord0.xy );
	float4 Movement = tex2D( AnimatedTexture, v.vTexCoord1 );
	float4 WaterColor = tex2D( Water, v.vWaterTexCoord );
	OutColor.rgb = WaterColor.rgb * Movement.a + OutColor.rgb* ( 1.0 +(-Movement.a) );
	OutColor.rgb += Movement.rgb;

	// Terra incognita
	float4 TerraIncognita = tex2D( TerraIncognitaTexture, v.vTerrainTexCoord );
	OutColor.rgb += ( TerraIncognita.g +(-0.25) )*1.33;

	return OutColor;
}

technique RiverShader
{
	pass p0
	{
		BlendEnable = true;
		AlphaTestEnable = true;

		VertexProgram = compile arbvp1 VertexShader_River();
		FragmentProgram = compile arbfp1 PixelShader_River();
	}
}
